<?php
function create_esxi_vm_snapshot($argv) {
	/* check number of arguments */
	if(count($argv) != 5) {
		echo "Usage: create_esxi_vm_snapshot ESXI_HOST ESXI_USERNAME ESXI_PASSWORD VM_PATH SNAPSHOT_NAME\n";
		exit(1);
	}

	/* fetch arguments */
	$esxi_host = escapeshellarg($argv[0]);
	$esxi_username = escapeshellarg($argv[1]);
	$esxi_password = escapeshellarg($argv[2]);
	$vm_path = escapeshellarg($argv[3]);
	$snapshot_name = escapeshellarg($argv[4]);

	/* execute main function */
	unset($result_array);
	exec("vmware-cmd --server $esxi_host --username $esxi_username --password $esxi_password $vm_path createsnapshot $snapshot_name 'create by dtas' 1 1 2>&1", $result_array, $return_value);
	/* didn't check return code, anyway, return them */
	foreach($result_array as $line) {
		echo $line . "\n";
	}
	exit($return_value);
}

